<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="container py-5">
    <div class="row mb-5">
        <div class="col-lg-6 mb-4">
            <h2 class="fw-bold mb-3">Our Story</h2>
            <p class="lead"><?php echo $site_settings['about_description'] ?? 'We are dedicated to making a positive impact in our community.'; ?></p>
        </div>
        <div class="col-lg-6">
            <div class="row text-center">
                <div class="col-6 mb-3">
                    <div class="p-3 bg-light rounded">
                        <h3 class="fw-bold text-primary mb-0"><?php echo number_format($statistics['volunteers'] ?? 0); ?>+</h3>
                        <p class="mb-0">Volunteers</p>
                    </div>
                </div>
                <div class="col-6 mb-3">
                    <div class="p-3 bg-light rounded">
                        <h3 class="fw-bold text-primary mb-0"><?php echo number_format($statistics['workshops'] ?? 0); ?>+</h3>
                        <p class="mb-0">Workshops</p>
                    </div>
                </div>
                <div class="col-6 mb-3">
                    <div class="p-3 bg-light rounded">
                        <h3 class="fw-bold text-primary mb-0"><?php echo number_format($statistics['partners'] ?? 0); ?>+</h3>
                        <p class="mb-0">Partners</p>
                    </div>
                </div>
                <div class="col-6 mb-3">
                    <div class="p-3 bg-light rounded">
                        <h3 class="fw-bold text-primary mb-0"><?php echo number_format($statistics['beneficiaries'] ?? 0); ?>+</h3>
                        <p class="mb-0">Beneficiaries</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row mb-5">
        <div class="col-md-6 mb-4">
            <div class="p-4 bg-light rounded h-100">
                <h3 class="fw-bold mb-3"><i class="fas fa-bullseye text-primary"></i> Our Mission</h3>
                <p>To empower individuals and communities through education, support, and sustainable development initiatives.</p>
            </div>
        </div>
        <div class="col-md-6 mb-4">
            <div class="p-4 bg-light rounded h-100">
                <h3 class="fw-bold mb-3"><i class="fas fa-eye text-primary"></i> Our Vision</h3>
                <p>A world where every person has the opportunity to reach their full potential and contribute to their community.</p>
            </div>
        </div>
    </div>
    
    <?php if (!empty($featured_volunteers)): ?>
        <div class="mb-5">
            <h3 class="fw-bold mb-4">Meet Our Volunteers</h3>
            <div class="row">
                <?php foreach (array_slice($featured_volunteers, 0, 4) as $volunteer): ?>
                    <div class="col-lg-3 col-md-4 col-6 mb-3">
                        <div class="text-center">
                            <?php if (!empty($volunteer->profile_photo)): ?>
                                <img src="<?php echo base_url('uploads/volunteers/' . $volunteer->profile_photo); ?>" 
                                     class="rounded-circle mb-2" 
                                     style="width: 100px; height: 100px; object-fit: cover;"
                                     alt="<?php echo htmlspecialchars($volunteer->full_name); ?>">
                            <?php else: ?>
                                <div class="rounded-circle bg-primary d-inline-flex align-items-center justify-content-center mb-2" 
                                     style="width: 100px; height: 100px;">
                                    <span class="text-white fs-2"><?php echo strtoupper(substr($volunteer->full_name, 0, 1)); ?></span>
                                </div>
                            <?php endif; ?>
                            <h6 class="fw-bold mb-0"><?php echo htmlspecialchars($volunteer->full_name); ?></h6>
                            <small class="text-muted"><?php echo htmlspecialchars($volunteer->occupation); ?></small>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="text-center mt-4">
                <a href="<?php echo base_url('volunteers'); ?>" class="btn btn-outline-primary">View All Volunteers</a>
            </div>
        </div>
    <?php endif; ?>
</div>